//Control Panel for Picking Letters
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class WordPickPanel extends JPanel
{
	private GameWord myWord;
	private LetterPickPanel myLPP;
	private StatusPanel mySP;
	private boolean debug;
	
	public WordPickPanel() throws IOException
	{
		super();
		debug = false;
		setLayout(new GridLayout(2,9));
		setBackground(Color.green);	
		mySP = new StatusPanel();
		myLPP = new LetterPickPanel();
		//setSize(100,400);
		add(mySP);
		add(myLPP);

	}
	
	public boolean play()
	{
		//update screen
		boolean results;
		setLetter();
		hideLetter();
				
		String letter = myLPP.getLetter();
		
		myWord = mySP.getWord();
		results =  myWord.testLetter(letter);
		updateStatus();
		if (debug) System.out.println("Playing letter "+myLPP.getLetter()+" "+myWord);		
		
		return results;
		

	}

	public boolean amIEnabled()
	{
		return myLPP.amIEnabled();
	}
	public boolean win()
	{
		return myWord.win();
	}
	public void setLetter()
	{
		mySP.setLetter(myLPP.getLetter());
	}
	public void hideLetter()
	{
		myLPP.hideLetter();
	}
	public void updateStatus()
	{
		mySP.setMask(myWord);
	}
	public void showWord()
	{
		mySP.showWord();
	}
	public String getGameWord()
	{
		return mySP.getGameWord();
	}

}
