//Control Panel for Picking Letters
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class WordPickPanel extends JPanel
{
	GameWord word;
	LetterPickPanel LPP;
	StatusPanel SP;
	
	public WordPickPanel() throws IOException
	{
		super();
		setLayout(new GridLayout(2,9));
		setBackground(Color.green);	
		SP = new StatusPanel();
		LPP = new LetterPickPanel();
		//setSize(100,400);
		add(SP);
		add(LPP);

	}
	
	public boolean play()
	{
		//update screen
		boolean results;
		setLetter();
		hideLetter();
				
		String letter = LPP.getLetter();
		
		word = SP.getWord();
		results =  word.testLetter(letter);
		updateStatus();
		System.out.println("Playing letter "+LPP.getLetter()+" "+word);		
		
		return results;
		

	}

	public boolean win()
	{
		return word.win();
	}
	public void setLetter()
	{
		SP.setLetter(LPP.getLetter());
	}
	public void hideLetter()
	{
		LPP.hideLetter();
	}
	public void updateStatus()
	{
		SP.setMask(word);
	}
	

}
