import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class LetterPickPanel extends JPanel implements ActionListener
{
	//A LetterPickPanel is a JPanel with a collection of JButtons on it
	//This allows the programmer to add command buttons to the program
	//and define their actions in a systematic way
	private JLabel showLetter;
	private JButton alphabet[] = new JButton[27];
	private String letters = "@ABCDEFGHIJKLMNOPQRSTUVWXYZ "   ;
	private String myLetter;
	public LetterPickPanel()
	{
		super();
		myLetter = " ";
		setLayout(new GridLayout(3,9));
		setBackground(Color.pink);
				
		showLetter = new JLabel("A");
		showLetter.setHorizontalAlignment(0); //swing constant CENTER = 0
		showLetter.setBackground(Color.white);
		showLetter.setFont(new Font("Times New Roman",1,30));
		
		add(showLetter);
		for (int i=1; i<27; i++)
	    {
			alphabet[i] = new JButton(letters.substring(i,i+1));
			alphabet[i].addActionListener(this);
			add(alphabet[i]);
	    }		
	}
	public void actionPerformed(ActionEvent ae)
	{
		int button;
		String command = ae.getActionCommand();
		System.out.println("LetterPick: "+ae.getActionCommand());
		
		button = ae.getActionCommand().charAt(0)-64;
		myLetter = command;
		showLetter.setText(myLetter);
		//hideLetter();  //alphabet[button].setVisible(false);
		
	}
	public String getLetter()
	{
		return myLetter;
	}
	public void setLetter(String letter)
	{
		myLetter = letter;
	}
	
	public void hideLetter()
	{
		alphabet[myLetter.charAt(0)-64].setVisible(false);
	}
}
