//Control Panel for Picking Letters
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class StatusPanel extends JPanel 
{
	//A StatusPanel is a JPanel with a collection of Labels on it
	//This allows the programmer to se the game status
	GameWord myCurrentWord;
	JLabel lblMask, lblLetter, lblWord;
	WordList allWords;
	public StatusPanel() throws IOException
	{
		super();

		allWords = new WordList();
		//The 0 indicates a fixed word return. Remove it for random word
		myCurrentWord = allWords.getNewWord();

		lblMask = new JLabel(myCurrentWord.printMask());
		lblMask.setSize(30,20);
		
		lblLetter = new JLabel("*");
		
		lblLetter.setHorizontalAlignment(0); //swing constant CENTER = 0
		lblLetter.setBackground(Color.white);
				
		lblWord  = new JLabel(myCurrentWord.getWord());
		lblWord.setHorizontalAlignment(0);
		
		lblMask.setFont(new Font("Courier",0,18));
		lblWord.setFont(new Font("Courier",0,18));
		lblLetter.setFont(new Font("Times New Roman",1,30));
		
		rePosition();
	}
	
	public void rePosition()
	{
		setLayout(new GridLayout());
		setBackground(Color.cyan);
        	add (lblMask);
        	add (lblLetter);
        	add (lblWord);
        
	}
	public void setLetter(String l)
	{
		lblLetter.setText(l);
	}
	public GameWord getWord()
	{
		return myCurrentWord;
	}
	public void setMask(GameWord w)
	{
		lblMask.setText(w.printMask());	
	}
}
