//Hangman 7
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.Color;

public class Hangman7 extends Frame implements ActionListener, AdjustmentListener
{
    	private 	int myCurrentImage;
private	ImageLibrary IL;
	private 	DisplayPanel dPanel;
	private 	TestColorPanel N,E,S,W,C;
	private	JButton cmdPlay;
	private 	JFrame gameFrame;
	private 	ControlPanel toolbar;
	private	ScoringPanel sPanel;
	private	StatusPanel STPanel;
	
	public Hangman7() throws IOException
	{
		myCurrentImage = 0;
		gameFrame = new JFrame("Hangman Version 7");
		IL = new ImageLibrary();
		//setSize(width, height)
		gameFrame.setSize(620,700);
		gameFrame.addWindowListener(new BasicWindowMonitor());
		dPanel = new DisplayPanel(IL.getImage(myCurrentImage));
		STPanel = new StatusPanel();
		//LPPanel = new LetterPickPanel();		
		cmdPlay   = new JButton("Play");
		cmdPlay.addActionListener(this);
		
		sPanel = new ScoringPanel();
		toolbar = new ControlPanel();
		rePosition();
		gameFrame.setVisible(true);
	}
	
	public void actionPerformed(ActionEvent ae)
	{
		System.out.println("Hangman: "+ae.getActionCommand());
		//code for displaying hangman image moved to here
		if (myCurrentImage < 10) 
		{
			myCurrentImage++;
			dPanel.displayImage(IL.getImage(myCurrentImage));
		}
		gameFrame.repaint();
		toolbar.repaint();
	}
	
	public void adjustmentValueChanged(AdjustmentEvent e)
	{
		//reads JScrollBar and displays appropriate image\
		System.out.println("In Hangman "+e.getValue());
		dPanel.displayImage(IL.getImage(e.getValue()));
		gameFrame.repaint();
		toolbar.repaint();
	}
	
	
 
public void rePosition()
	{
        gameFrame.getContentPane ().add (sPanel, BorderLayout.NORTH);
        gameFrame.getContentPane ().add (STPanel, BorderLayout.SOUTH);
        gameFrame.getContentPane ().add (toolbar, BorderLayout.EAST);
        gameFrame.getContentPane ().add (dPanel, BorderLayout.CENTER);
        gameFrame.getContentPane ().add (cmdPlay, BorderLayout.WEST);
	}
	
	public static void main(String args[]) throws IOException
	{
		Hangman7 hm7 = new Hangman7();
		
	}
}



