public class GameWord
{
	private String myWord;
	private String myWorkWord;
	private String myMask;
	private int    myGuesses;
	
	public GameWord(String s)
	{
		myWord = s;
		myWorkWord = s;
		myMask = makeMask(s);
		myGuesses = s.length();
	}
	
	private String makeMask(String s)
	{
		//Creates blanks for String s
		String temp = "";
		for (int i=0; i<s.length(); i++)
		{
			temp = temp + "_";
		}
		return temp;
		
	}
	public String printMask()
	{
		String temp="";
		for (int i = 0; i<myMask.length(); i++)
		{
			temp = temp + myMask.charAt(i)+" ";
		}
		return temp;
	}

	public String insertLetter(String letter, String word, int position)
	{
		String left,right;
		left = word.substring(0,position);
		right = word.substring(position+1);
		
		return left+letter+right;
	}
	
	public boolean testLetter(String l)
	{
		boolean found = false;
		int pos;
		pos = myWorkWord.indexOf(l);
   
		while (pos != -1)
		{
			found = true;
			myWorkWord = insertLetter("*",myWorkWord,pos);
			myMask = insertLetter(l,myMask,pos);
			pos = myWorkWord.indexOf(l);
			myGuesses--;
		}
						
		return found;
	}
	
	public String getWord()
	{
		return myWord;
	}
	public String getWorkWord()
	{
		return myWorkWord;
	}
	public String getMask()
	{
		return myMask;
	}
	public int getGuesses()
	{
		return myGuesses;
	}
	public void setGuesses(int x)
	{
		myGuesses = x;
	}
	
	public String toString()
	{
		return myWorkWord+" "+printMask()+"G: "+myGuesses;
	}
	public boolean win()
	{
		return myGuesses == 0;
	}
}