//Hangman 5
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.Color;

public class Hangman5 extends Frame implements ActionListener, AdjustmentListener
{
    private int myCurrentImage;
	private	ImageLibrary IL;
	private DisplayPanel dPanel;
	private TestColorPanel N,E,S,W,C;
	private	JButton cmdPlay;
	private JFrame gameFrame;
	private ControlPanel toolbar;
	private	ScoringPanel sPanel;
	
	public Hangman5()
	{
		myCurrentImage = 0;
		
		gameFrame = new JFrame("Hangman Version 5");

		IL = new ImageLibrary();
		//setSize(width, height)
		gameFrame.setSize(520,550);
		gameFrame.addWindowListener(new BasicWindowMonitor());
		
		dPanel = new DisplayPanel(IL.getImage(myCurrentImage));
		
		cmdPlay   = new JButton("Play");

		cmdPlay.addActionListener(this);
		
		sPanel = new ScoringPanel();
		toolbar = new ControlPanel();
		S = new TestColorPanel(Color.yellow);
		W = new TestColorPanel(Color.cyan);
		rePosition();

		gameFrame.setVisible(true);

	}
	
	public void actionPerformed(ActionEvent ae)
	{
		System.out.println("Hangman: "+ae.getActionCommand());
		//code for displaying hangman image moved to here
		if (myCurrentImage < 10) 
		{
			myCurrentImage++;
			dPanel.displayImage(IL.getImage(myCurrentImage));
		}
		gameFrame.repaint();
		toolbar.repaint();
	}
	
	
 
public void adjustmentValueChanged(AdjustmentEvent e)
	{
		//reads JScrollBar and displays appropriate image\
		System.out.println("In Hangman "+e.getValue());
		dPanel.displayImage(IL.getImage(e.getValue()));
		gameFrame.repaint();
		toolbar.repaint();
	}
	
	public void rePosition()
	{
        gameFrame.getContentPane ().add (sPanel, BorderLayout.NORTH);
        gameFrame.getContentPane ().add (S, BorderLayout.SOUTH);
        gameFrame.getContentPane ().add (toolbar, BorderLayout.EAST);
        gameFrame.getContentPane ().add (dPanel, BorderLayout.CENTER);
        gameFrame.getContentPane ().add (cmdPlay, BorderLayout.WEST);
	}
	
	public static void main(String args[])
	{
		Hangman5 hm5 = new Hangman5();
		
	}
}
