//Hangman 3
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.Color;

public class Hangman3 extends Frame implements ActionListener, AdjustmentListener
{
	private ImageLibrary IL;
	private DisplayPanel dPanel;
	private TestColorPanel N,E,S,W,C;
	private JScrollBar vsbPickImage;	
	private JFrame gameFrame;
	private ControlPanel toolbar;
	
	public Hangman3()	{
		gameFrame = new JFrame("Hangman Version 3");
		IL = new ImageLibrary();
		//setSize(width, height)
		gameFrame.setSize(520,550);
		gameFrame.addWindowListener(new BasicWindowMonitor());
		dPanel = new DisplayPanel(IL.getImage(0));
		
	    //Scrollbar parameters (orientation, value, extent, minimum, maximum)
		vsbPickImage = new JScrollBar(JScrollBar.VERTICAL,0,0,0,10);
		vsbPickImage.addAdjustmentListener(this);
		
		N = new TestColorPanel(Color.green);
		toolbar = new ControlPanel();
		S = new TestColorPanel(Color.yellow);
		W = new TestColorPanel(Color.cyan);
		rePosition();

		gameFrame.setVisible(true);
	}
	
	public void actionPerformed(ActionEvent ae)
	{
		System.out.println("Hangman: "+ae.getActionCommand());
	}
	public void adjustmentValueChanged(AdjustmentEvent e)
	{
		//reads JScrollBar and displays appropriate image\
		System.out.println("In Hangman "+e.getValue());
		dPanel.displayImage(IL.getImage(e.getValue()));
		gameFrame.repaint();
		toolbar.repaint();
	}
	public void rePosition()
	{
        gameFrame.getContentPane ().add (N, BorderLayout.NORTH);
        gameFrame.getContentPane ().add (S, BorderLayout.SOUTH);
        gameFrame.getContentPane ().add (toolbar, BorderLayout.EAST);
        gameFrame.getContentPane ().add (dPanel, BorderLayout.CENTER);
        gameFrame.getContentPane ().add (vsbPickImage, BorderLayout.WEST);
	}
	public static void main(String args[])
	{
		Hangman3 hm3 = new Hangman3();
	}
}
