//Hangman 10
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.Color;

public class Hangman implements ActionListener, AdjustmentListener
{
    private int myCurrentImage;
	private	ImageLibrary myIL;
	private DisplayPanel myDPanel;
	private TestColorPanel N,E,S,W,C;
	private	JButton cmdPlay;
	private JFrame myGameFrame;
	private ControlPanel myToolBar;
	private	ScoringPanel mySPanel;
	private	WordPickPanel myWPPanel;
	private boolean myDone;
	private boolean myWin;
	private boolean debug;
	
	public Hangman() throws IOException
	{
		debug = false;
		myDone = false;
		myWin = false;
		myCurrentImage = 0;
		
		myGameFrame = new JFrame("Hangman (c)ASKSoftware 2005");
		
		myIL = new ImageLibrary();

		//setSize(width, height)
		myGameFrame.setSize(620,700);
		myGameFrame.addWindowListener(new BasicWindowMonitor());
		
		myDPanel = new DisplayPanel(myIL.getImage(myCurrentImage));
		myWPPanel = new WordPickPanel();
				
		cmdPlay   = new JButton("Play");
		cmdPlay.addActionListener(this);
		//cmdPlay.setEnabled(false);
		
		mySPanel = new ScoringPanel();
		myToolBar = new ControlPanel();

		rePosition();

		myGameFrame.setVisible(true);

	}
	public Hangman(int win, int lose) throws IOException
	{
		myDone = false;
		myWin = false;
		myCurrentImage = 0;
		
		myGameFrame = new JFrame("Hangman (c)ASKSoftward 2005+");

		myIL = new ImageLibrary();
		//setSize(width, height)
		myGameFrame.setSize(620,700);
		myGameFrame.addWindowListener(new BasicWindowMonitor());
		
		myDPanel = new DisplayPanel(myIL.getImage(myCurrentImage));
		myWPPanel = new WordPickPanel();
				
		cmdPlay   = new JButton("Play");
		cmdPlay.addActionListener(this);
		
		mySPanel = new ScoringPanel(win, lose);
		myToolBar = new ControlPanel();

		rePosition();

		myGameFrame.setVisible(true);

		
	}
	
	public boolean getDone()
	{
		return myDone;
	}
	
	public int getWin()
	{
		return mySPanel.getWin();
	}
	public int getLose()
	{
		return mySPanel.getLose();
	}
	
	public void actionPerformed(ActionEvent ae)
	{
		boolean cleanup = false;
		int replay;
		String message;
		
		if (debug) System.out.println("Hangman: "+ae.getActionCommand());
		
	  	if (myWPPanel.amIEnabled())
	  	{  	
	  		if ( myWPPanel.play() )
			{
				//check for win
				if (myWPPanel.win())
				{
					int x = mySPanel.getWin();
					x++;
					mySPanel.setWin( x);
					//reset game
					myWin = true;
					cleanup = true;
				}
				else
				{
					//System.out.println()
				}
			
			}
			else
			{
				//do lose stuff
				myCurrentImage++;
				if (myCurrentImage >= 10)
				{
					int x = mySPanel.getLose();
					x++;
					mySPanel.setLose(x);
					myWin = false;
					cleanup = true;
					//reset
				}
				else
				{
					myDPanel.displayImage(myIL.getImage(myCurrentImage));
				}
			}
			if (cleanup)
			{
				myWPPanel.showWord();
				String tempWord = myWPPanel.getGameWord();
		
				if(myWin)
				{
					message = "Word was: "+tempWord+ ".\n You Win! \n New Game?";
				}
				else
				{
					message = "Word was: "+tempWord+".\n You Lose! \n New Game?";
				}
			
			    replay = JOptionPane.showConfirmDialog(myGameFrame, message, "GAME OVER!", JOptionPane.YES_NO_OPTION);
			    if (replay == 0)
			    {
					myDone = true;
					myGameFrame.dispose();
				}
				else
				{
					System.exit(0);
				}
					
			
			}		
			myGameFrame.repaint();
			myToolBar.repaint();
		}
		else
		{
			JOptionPane.showMessageDialog(myGameFrame, "Select a LETTER before pressing PLAY", "Error", JOptionPane.INFORMATION_MESSAGE);
			if (debug) System.out.println("Choose a letter");
		}
	}
	
	public void adjustmentValueChanged(AdjustmentEvent e)
	{
		//reads JScrollBar and displays appropriate image\
		if (debug) System.out.println("In Hangman "+e.getValue());
		myDPanel.displayImage(myIL.getImage(e.getValue()));
		myGameFrame.repaint();
		myToolBar.repaint();
	}
	
	public void rePosition()
	{
        myGameFrame.getContentPane ().add (mySPanel, BorderLayout.NORTH);
        myGameFrame.getContentPane ().add (myWPPanel, BorderLayout.SOUTH);
        myGameFrame.getContentPane ().add (myToolBar, BorderLayout.EAST);
        myGameFrame.getContentPane ().add (myDPanel, BorderLayout.CENTER);
        myGameFrame.getContentPane ().add (cmdPlay, BorderLayout.WEST);
	}

	public static void main(String args[]) throws IOException
	{
		int rp = 1;
		Hangman hm = new Hangman();
		while(true)
		{
			if (!hm.getDone())
			{
				while (!hm.getDone());
				hm = new Hangman(hm.getWin(),hm.getLose());

			}
		}
		
		
	}
}
